using System;
using System.Diagnostics;

namespace Implab {
    class PromiseActionReaction<T> : PromiseReaction<T> {
        readonly Deferred m_next;

        public IPromise Promise {
            get { return m_next.Promise; }
        }

        public PromiseActionReaction(Action<T> fulfilled, Action<Exception> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Func<T, IPromise> fulfilled, Func<Exception, IPromise> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Action<T> fulfilled, Func<Exception, IPromise> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        public PromiseActionReaction(Func<T, IPromise> fulfilled, Action<Exception> rejected, IDispatcher dispatcher) : base(dispatcher) {
            m_next = new Deferred(dispatcher);
            if (fulfilled != null)
                FulfilHandler = PromiseHandler.Create(fulfilled, m_next);

            if (rejected != null)
                RejectHandler = PromiseHandler.Create(rejected, m_next);
        }

        protected override void DefaultReject(Exception reason) {
            m_next.Reject(reason);
        }

        protected override void DefaultResolve(T result) {
            m_next.Resolve();
        }
    }
}